from nebuloid.api.context import NebuloidContext
class NebuloidPluginManager:
    def __init__(self, manifest, orm, expose_api, plugins_dir="plugins"):
        self.plugins = []
        self.manifest = manifest
        self.orm = orm
        self.expose_api = expose_api
        self.plugins_dir = plugins_dir

    def mount(self):
        for plugin, value in self.manifest.data['plugins'].items():
            if plugin.startswith('_'):
                module = __import__(plugin[1:], fromlist=['mount'])
            else:
                module = __import__(f'{self.plugins_dir}.{plugin}', fromlist=['mount'])
            if hasattr(module, 'mount'):
                context = NebuloidContext(self.manifest, self.orm, value)
                context.expose_api = self.expose_api
                module.mount(context)
                self.plugins.append(module)

            else:
                print(f"Plugin {plugin} does not have a mount function.")

    def get_plugins(self):
        return self.plugins